//     Underscore.js 1.4.1
//     http://underscorejs.org
//     (c) 2009-2012 Jeremy Ashkenas, DocumentCloud Inc.
//     Underscore may be freely distributed under the MIT license.
(function(){var e=this,t=e._,n={},r=Array.prototype,i=Object.prototype,s=Function.prototype,o=r.push,u=r.slice,a=r.concat,f=r.unshift,l=i.toString,c=i.hasOwnProperty,h=r.forEach,p=r.map,d=r.reduce,v=r.reduceRight,m=r.filter,g=r.every,y=r.some,b=r.indexOf,w=r.lastIndexOf,E=Array.isArray,S=Object.keys,x=s.bind,T=function(e){if(e instanceof T)return e;if(!(this instanceof T))return new T(e);this._wrapped=e};typeof exports!="undefined"?(typeof module!="undefined"&&module.exports&&(exports=module.exports=T),exports._=T):e._=T,T.VERSION="1.4.1";var N=T.each=T.forEach=function(e,t,r){if(h&&e.forEach===h)e.forEach(t,r);else if(e.length===+e.length){for(var i=0,s=e.length;i<s;i++)if(t.call(r,e[i],i,e)===n)return}else for(var o in e)if(T.has(e,o)&&t.call(r,e[o],o,e)===n)return};T.map=T.collect=function(e,t,n){var r=[];return p&&e.map===p?e.map(t,n):(N(e,function(e,i,s){r[r.length]=t.call(n,e,i,s)}),r)},T.reduce=T.foldl=T.inject=function(e,t,n,r){var i=arguments.length>2;if(d&&e.reduce===d)return r&&(t=T.bind(t,r)),i?e.reduce(t,n):e.reduce(t);N(e,function(e,s,o){i?n=t.call(r,n,e,s,o):(n=e,i=!0)});if(!i)throw new TypeError("Reduce of empty array with no initial value");return n},T.reduceRight=T.foldr=function(e,t,n,r){var i=arguments.length>2;if(v&&e.reduceRight===v)return r&&(t=T.bind(t,r)),arguments.length>2?e.reduceRight(t,n):e.reduceRight(t);var s=e.length;if(s!==+s){var o=T.keys(e);s=o.length}N(e,function(u,a,f){a=o?o[--s]:--s,i?n=t.call(r,n,e[a],a,f):(n=e[a],i=!0)});if(!i)throw new TypeError("Reduce of empty array with no initial value");return n},T.find=T.detect=function(e,t,n){var r;return C(e,function(e,i,s){if(t.call(n,e,i,s))return r=e,!0}),r},T.filter=T.select=function(e,t,n){var r=[];return m&&e.filter===m?e.filter(t,n):(N(e,function(e,i,s){t.call(n,e,i,s)&&(r[r.length]=e)}),r)},T.reject=function(e,t,n){var r=[];return N(e,function(e,i,s){t.call(n,e,i,s)||(r[r.length]=e)}),r},T.every=T.all=function(e,t,r){t||(t=T.identity);var i=!0;return g&&e.every===g?e.every(t,r):(N(e,function(e,s,o){if(!(i=i&&t.call(r,e,s,o)))return n}),!!i)};var C=T.some=T.any=function(e,t,r){t||(t=T.identity);var i=!1;return y&&e.some===y?e.some(t,r):(N(e,function(e,s,o){if(i||(i=t.call(r,e,s,o)))return n}),!!i)};T.contains=T.include=function(e,t){var n=!1;return b&&e.indexOf===b?e.indexOf(t)!=-1:(n=C(e,function(e){return e===t}),n)},T.invoke=function(e,t){var n=u.call(arguments,2);return T.map(e,function(e){return(T.isFunction(t)?t:e[t]).apply(e,n)})},T.pluck=function(e,t){return T.map(e,function(e){return e[t]})},T.where=function(e,t){return T.isEmpty(t)?[]:T.filter(e,function(e){for(var n in t)if(t[n]!==e[n])return!1;return!0})},T.max=function(e,t,n){if(!t&&T.isArray(e)&&e[0]===+e[0]&&e.length<65535)return Math.max.apply(Math,e);if(!t&&T.isEmpty(e))return-Infinity;var r={computed:-Infinity};return N(e,function(e,i,s){var o=t?t.call(n,e,i,s):e;o>=r.computed&&(r={value:e,computed:o})}),r.value},T.min=function(e,t,n){if(!t&&T.isArray(e)&&e[0]===+e[0]&&e.length<65535)return Math.min.apply(Math,e);if(!t&&T.isEmpty(e))return Infinity;var r={computed:Infinity};return N(e,function(e,i,s){var o=t?t.call(n,e,i,s):e;o<r.computed&&(r={value:e,computed:o})}),r.value},T.shuffle=function(e){var t,n=0,r=[];return N(e,function(e){t=T.random(n++),r[n-1]=r[t],r[t]=e}),r};var k=function(e){return T.isFunction(e)?e:function(t){return t[e]}};T.sortBy=function(e,t,n){var r=k(t);return T.pluck(T.map(e,function(e,t,i){return{value:e,index:t,criteria:r.call(n,e,t,i)}}).sort(function(e,t){var n=e.criteria,r=t.criteria;if(n!==r){if(n>r||n===void 0)return 1;if(n<r||r===void 0)return-1}return e.index<t.index?-1:1}),"value")};var L=function(e,t,n,r){var i={},s=k(t);return N(e,function(t,o){var u=s.call(n,t,o,e);r(i,u,t)}),i};T.groupBy=function(e,t,n){return L(e,t,n,function(e,t,n){(T.has(e,t)?e[t]:e[t]=[]).push(n)})},T.countBy=function(e,t,n){return L(e,t,n,function(e,t,n){T.has(e,t)||(e[t]=0),e[t]++})},T.sortedIndex=function(e,t,n,r){n=n==null?T.identity:k(n);var i=n.call(r,t),s=0,o=e.length;while(s<o){var u=s+o>>>1;n.call(r,e[u])<i?s=u+1:o=u}return s},T.toArray=function(e){return e?e.length===+e.length?u.call(e):T.values(e):[]},T.size=function(e){return e.length===+e.length?e.length:T.keys(e).length},T.first=T.head=T.take=function(e,t,n){return t!=null&&!n?u.call(e,0,t):e[0]},T.initial=function(e,t,n){return u.call(e,0,e.length-(t==null||n?1:t))},T.last=function(e,t,n){return t!=null&&!n?u.call(e,Math.max(e.length-t,0)):e[e.length-1]},T.rest=T.tail=T.drop=function(e,t,n){return u.call(e,t==null||n?1:t)},T.compact=function(e){return T.filter(e,function(e){return!!e})};var A=function(e,t,n){return N(e,function(e){T.isArray(e)?t?o.apply(n,e):A(e,t,n):n.push(e)}),n};T.flatten=function(e,t){return A(e,t,[])},T.without=function(e){return T.difference(e,u.call(arguments,1))},T.uniq=T.unique=function(e,t,n,r){var i=n?T.map(e,n,r):e,s=[],o=[];return N(i,function(n,r){if(t?!r||o[o.length-1]!==n:!T.contains(o,n))o.push(n),s.push(e[r])}),s},T.union=function(){return T.uniq(a.apply(r,arguments))},T.intersection=function(e){var t=u.call(arguments,1);return T.filter(T.uniq(e),function(e){return T.every(t,function(t){return T.indexOf(t,e)>=0})})},T.difference=function(e){var t=a.apply(r,u.call(arguments,1));return T.filter(e,function(e){return!T.contains(t,e)})},T.zip=function(){var e=u.call(arguments),t=T.max(T.pluck(e,"length")),n=new Array(t);for(var r=0;r<t;r++)n[r]=T.pluck(e,""+r);return n},T.object=function(e,t){var n={};for(var r=0,i=e.length;r<i;r++)t?n[e[r]]=t[r]:n[e[r][0]]=e[r][1];return n},T.indexOf=function(e,t,n){var r=0,i=e.length;if(n){if(typeof n!="number")return r=T.sortedIndex(e,t),e[r]===t?r:-1;r=n<0?Math.max(0,i+n):n}if(b&&e.indexOf===b)return e.indexOf(t,n);for(;r<i;r++)if(e[r]===t)return r;return-1},T.lastIndexOf=function(e,t,n){var r=n!=null;if(w&&e.lastIndexOf===w)return r?e.lastIndexOf(t,n):e.lastIndexOf(t);var i=r?n:e.length;while(i--)if(e[i]===t)return i;return-1},T.range=function(e,t,n){arguments.length<=1&&(t=e||0,e=0),n=arguments[2]||1;var r=Math.max(Math.ceil((t-e)/n),0),i=0,s=new Array(r);while(i<r)s[i++]=e,e+=n;return s};var O=function(){};T.bind=function(t,n){var r,i;if(t.bind===x&&x)return x.apply(t,u.call(arguments,1));if(!T.isFunction(t))throw new TypeError;return i=u.call(arguments,2),r=function(){if(this instanceof r){O.prototype=t.prototype;var e=new O,s=t.apply(e,i.concat(u.call(arguments)));return Object(s)===s?s:e}return t.apply(n,i.concat(u.call(arguments)))}},T.bindAll=function(e){var t=u.call(arguments,1);return t.length==0&&(t=T.functions(e)),N(t,function(t){e[t]=T.bind(e[t],e)}),e},T.memoize=function(e,t){var n={};return t||(t=T.identity),function(){var r=t.apply(this,arguments);return T.has(n,r)?n[r]:n[r]=e.apply(this,arguments)}},T.delay=function(e,t){var n=u.call(arguments,2);return setTimeout(function(){return e.apply(null,n)},t)},T.defer=function(e){return T.delay.apply(T,[e,1].concat(u.call(arguments,1)))},T.throttle=function(e,t){var n,r,i,s,o,u,a=T.debounce(function(){o=s=!1},t);return function(){n=this,r=arguments;var f=function(){i=null,o&&(u=e.apply(n,r)),a()};return i||(i=setTimeout(f,t)),s?o=!0:(s=!0,u=e.apply(n,r)),a(),u}},T.debounce=function(e,t,n){var r,i;return function(){var s=this,o=arguments,u=function(){r=null,n||(i=e.apply(s,o))},a=n&&!r;return clearTimeout(r),r=setTimeout(u,t),a&&(i=e.apply(s,o)),i}},T.once=function(e){var t=!1,n;return function(){return t?n:(t=!0,n=e.apply(this,arguments),e=null,n)}},T.wrap=function(e,t){return function(){var n=[e];return o.apply(n,arguments),t.apply(this,n)}},T.compose=function(){var e=arguments;return function(){var t=arguments;for(var n=e.length-1;n>=0;n--)t=[e[n].apply(this,t)];return t[0]}},T.after=function(e,t){return e<=0?t():function(){if(--e<1)return t.apply(this,arguments)}},T.keys=S||function(e){if(e!==Object(e))throw new TypeError("Invalid object");var t=[];for(var n in e)T.has(e,n)&&(t[t.length]=n);return t},T.values=function(e){var t=[];for(var n in e)T.has(e,n)&&t.push(e[n]);return t},T.pairs=function(e){var t=[];for(var n in e)T.has(e,n)&&t.push([n,e[n]]);return t},T.invert=function(e){var t={};for(var n in e)T.has(e,n)&&(t[e[n]]=n);return t},T.functions=T.methods=function(e){var t=[];for(var n in e)T.isFunction(e[n])&&t.push(n);return t.sort()},T.extend=function(e){return N(u.call(arguments,1),function(t){for(var n in t)e[n]=t[n]}),e},T.pick=function(e){var t={},n=a.apply(r,u.call(arguments,1));return N(n,function(n){n in e&&(t[n]=e[n])}),t},T.omit=function(e){var t={},n=a.apply(r,u.call(arguments,1));for(var i in e)T.contains(n,i)||(t[i]=e[i]);return t},T.defaults=function(e){return N(u.call(arguments,1),function(t){for(var n in t)e[n]==null&&(e[n]=t[n])}),e},T.clone=function(e){return T.isObject(e)?T.isArray(e)?e.slice():T.extend({},e):e},T.tap=function(e,t){return t(e),e};var M=function(e,t,n,r){if(e===t)return e!==0||1/e==1/t;if(e==null||t==null)return e===t;e instanceof T&&(e=e._wrapped),t instanceof T&&(t=t._wrapped);var i=l.call(e);if(i!=l.call(t))return!1;switch(i){case"[object String]":return e==String(t);case"[object Number]":return e!=+e?t!=+t:e==0?1/e==1/t:e==+t;case"[object Date]":case"[object Boolean]":return+e==+t;case"[object RegExp]":return e.source==t.source&&e.global==t.global&&e.multiline==t.multiline&&e.ignoreCase==t.ignoreCase}if(typeof e!="object"||typeof t!="object")return!1;var s=n.length;while(s--)if(n[s]==e)return r[s]==t;n.push(e),r.push(t);var o=0,u=!0;if(i=="[object Array]"){o=e.length,u=o==t.length;if(u)while(o--)if(!(u=M(e[o],t[o],n,r)))break}else{var a=e.constructor,f=t.constructor;if(a!==f&&!(T.isFunction(a)&&a instanceof a&&T.isFunction(f)&&f instanceof f))return!1;for(var c in e)if(T.has(e,c)){o++;if(!(u=T.has(t,c)&&M(e[c],t[c],n,r)))break}if(u){for(c in t)if(T.has(t,c)&&!(o--))break;u=!o}}return n.pop(),r.pop(),u};T.isEqual=function(e,t){return M(e,t,[],[])},T.isEmpty=function(e){if(e==null)return!0;if(T.isArray(e)||T.isString(e))return e.length===0;for(var t in e)if(T.has(e,t))return!1;return!0},T.isElement=function(e){return!!e&&e.nodeType===1},T.isArray=E||function(e){return l.call(e)=="[object Array]"},T.isObject=function(e){return e===Object(e)},N(["Arguments","Function","String","Number","Date","RegExp"],function(e){T["is"+e]=function(t){return l.call(t)=="[object "+e+"]"}}),T.isArguments(arguments)||(T.isArguments=function(e){return!!e&&!!T.has(e,"callee")}),typeof /./!="function"&&(T.isFunction=function(e){return typeof e=="function"}),T.isFinite=function(e){return T.isNumber(e)&&isFinite(e)},T.isNaN=function(e){return T.isNumber(e)&&e!=+e},T.isBoolean=function(e){return e===!0||e===!1||l.call(e)=="[object Boolean]"},T.isNull=function(e){return e===null},T.isUndefined=function(e){return e===void 0},T.has=function(e,t){return c.call(e,t)},T.noConflict=function(){return e._=t,this},T.identity=function(e){return e},T.times=function(e,t,n){for(var r=0;r<e;r++)t.call(n,r)},T.random=function(e,t){return t==null&&(t=e,e=0),e+(0|Math.random()*(t-e+1))};var _={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","/":"&#x2F;"}};_.unescape=T.invert(_.escape);var D={escape:new RegExp("["+T.keys(_.escape).join("")+"]","g"),unescape:new RegExp("("+T.keys(_.unescape).join("|")+")","g")};T.each(["escape","unescape"],function(e){T[e]=function(t){return t==null?"":(""+t).replace(D[e],function(t){return _[e][t]})}}),T.result=function(e,t){if(e==null)return null;var n=e[t];return T.isFunction(n)?n.call(e):n},T.mixin=function(e){N(T.functions(e),function(t){var n=T[t]=e[t];T.prototype[t]=function(){var e=[this._wrapped];return o.apply(e,arguments),F.call(this,n.apply(T,e))}})};var P=0;T.uniqueId=function(e){var t=P++;return e?e+t:t},T.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var H=/(.)^/,B={"'":"'","\\":"\\","\r":"r","\n":"n"," ":"t","\u2028":"u2028","\u2029":"u2029"},j=/\\|'|\r|\n|\t|\u2028|\u2029/g;T.template=function(e,t,n){n=T.defaults({},n,T.templateSettings);var r=new RegExp([(n.escape||H).source,(n.interpolate||H).source,(n.evaluate||H).source].join("|")+"|$","g"),i=0,s="__p+='";e.replace(r,function(t,n,r,o,u){s+=e.slice(i,u).replace(j,function(e){return"\\"+B[e]}),s+=n?"'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'":r?"'+\n((__t=("+r+"))==null?'':__t)+\n'":o?"';\n"+o+"\n__p+='":"",i=u+t.length}),s+="';\n",n.variable||(s="with(obj||{}){\n"+s+"}\n"),s="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+s+"return __p;\n";try{var o=new Function(n.variable||"obj","_",s)}catch(u){throw u.source=s,u}if(t)return o(t,T);var a=function(e){return o.call(this,e,T)};return a.source="function("+(n.variable||"obj")+"){\n"+s+"}",a},T.chain=function(e){return T(e).chain()};var F=function(e){return this._chain?T(e).chain():e};T.mixin(T),N(["pop","push","reverse","shift","sort","splice","unshift"],function(e){var t=r[e];T.prototype[e]=function(){var n=this._wrapped;return t.apply(n,arguments),(e=="shift"||e=="splice")&&n.length===0&&delete n[0],F.call(this,n)}}),N(["concat","join","slice"],function(e){var t=r[e];T.prototype[e]=function(){return F.call(this,t.apply(this._wrapped,arguments))}}),T.extend(T.prototype,{chain:function(){return this._chain=!0,this},value:function(){return this._wrapped}})}).call(this);


/*
* Point
* Visit http://createjs.com/ for documentation, updates and examples.
*
* Copyright (c) 2010 gskinner.com, inc.
*
* Permission is hereby granted, free of charge, to any person
* obtaining a copy of this software and associated documentation
* files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use,
* copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following
* conditions:
*
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
this.createjs=this.createjs||{};(function(){var Point=function(x,y){this.initialize(x,y);}
var p=Point.prototype;p.x=0;p.y=0;p.initialize=function(x,y){this.x=(x==null?0:x);this.y=(y==null?0:y);}
p.clone=function(){return new Point(this.x,this.y);}
p.toString=function(){return"[Point (x="+this.x+" y="+this.y+")]";}
createjs.Point=Point;}());

/*
* Rectangle
* Visit http://createjs.com/ for documentation, updates and examples.
*
* Copyright (c) 2010 gskinner.com, inc.
*
* Permission is hereby granted, free of charge, to any person
* obtaining a copy of this software and associated documentation
* files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use,
* copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following
* conditions:
*
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/this.createjs=this.createjs||{};(function(){var Rectangle=function(x,y,width,height){this.initialize(x,y,width,height);}
var p=Rectangle.prototype;p.x=0;p.y=0;p.width=0;p.height=0;p.initialize=function(x,y,width,height){this.x=(x==null?0:x);this.y=(y==null?0:y);this.width=(width==null?0:width);this.height=(height==null?0:height);}
p.clone=function(){return new Rectangle(this.x,this.y,this.width,this.height);}
p.toString=function(){return"[Rectangle (x="+this.x+" y="+this.y+" width="+this.width+" height="+this.height+")]";}
createjs.Rectangle=Rectangle;}());


// CreateJS imports
_.extend(this, createjs);
Point.prototype.toString = function(){ return "("+this.x+","+this.y+")";}





//   WordBalloon.jsfl 1.0
//   
//   http://sixsided.org
//   (c) 2013-2014
//   WordBalloon.jsfl may be freely distributed under the MIT license.

// Thu Jun 6 23:41:49 PDT 2013   Added jitter to work around Flash's weird XOR overdraw behavior making the 
//                               balloon outline invisible.



function trace(){
  fl.trace(_.toArray(arguments).join(' '));
}

// trace('Entering WordBalloon.jsfl...'); // runs 4 times on starting Flash CS6

function transformPoint( pt,  mat )
{
	var x = pt.x*mat.a + pt.y*mat.c + mat.tx;
	var y = pt.x*mat.b + pt.y*mat.d + mat.ty;

	pt.x = x;
	pt.y = y;

	return;
}

function jitter(){ return 3 * Math.random() - 1.5; }

 function drawPolygon(poly){
   var viewMat = fl.getDocumentDOM().viewMatrix;
   var xfp = function(p){
     var tmp = {x:p.x + jitter(), y:p.y + jitter()};
     transformPoint(tmp, viewMat);
     return tmp;
   };
   
   var p = xfp(poly[0]);
   fl.drawingLayer.moveTo(p.x,p.y);
   for(var i=0;i<poly.length;i++)
   {
     p = xfp(poly[i]);
     fl.drawingLayer.lineTo(p.x,p.y);
   }
   p = xfp(poly[0]);
   fl.drawingLayer.lineTo(p.x,p.y);
   // trace('drawPoly', poly.length, 'points');
 }
  


function renderPath(poly) {
    trace('renderPath:', poly.join(' '));
    // allocate a path
    var path = fl.drawingLayer.newPath();

    // add the segments
    _.each(poly, function(e){ 
      trace(' renderPath adding point', e, 'to path', path);      
      path.addPoint(e.x,e.y); 
    });
    path.close();    
    trace(' renderPath making shape...');
    path.makeShape();
    trace('renderPath completed.');
    // return path;  
} 


////////////// Geometry  
var TWOPI = Math.PI * 2;

function p(x,y) { return new Point(x,y); }


function xyToThetaPct(x, y) {
  var rp = Math.atan2(y, x) / ( 2 * Math.PI);
  var pct = rp < 0 ? (1 + rp) : rp;    
  return pct;
}


function xyToTheta(x, y) {
  var rp = Math.atan2(y, x);
  return rp < 0 ? (TWOPI + rp) : rp;    
}


function pointPolar(magnitude, angle) {
    var p = new Point();
    var rads = angle; //(angle/180) * Math.PI;
    p.x = magnitude * Math.cos(rads);
    p.y = magnitude * Math.sin(rads);
    return p;
}

function pointDistance(p1, p2){
  var m = new Point(p2.x - p1.x, p2.y - p1.y);
  return Math.sqrt(m.x * m.x + m.y * m.y);
}

function pointSum(a,b){
  return new Point(a.x+b.x, a.y+b.y);
}


function linesIntersect(a1, a2, b1, b2, ptIntersection)
{
   // Denominator for ua and ub are the same, so store this calculation
   var d =
      (b2.y - b1.y) * (a2.x - a1.x) -
      (b2.x - b1.x) * (a2.y - a1.y);

   //n_a and n_b are calculated as seperate values for readability
   var n_a =
      (b2.x - b1.x) * (a1.y - b1.y) -
      (b2.y - b1.y) * (a1.x - b1.x);

   var n_b =
      (a2.x - a1.x) * (a1.y - b1.y) -
      (a2.y - a1.y) * (a1.x - b1.x);

   // Make sure there is not a division by zero - this also indicates that
   // the lines are parallel.  
   // If n_a and n_b were both equal to zero the lines would be on top of each 
   // other (coincidental).  This check is not done because it is not 
   // necessary for this implementation (the parallel check accounts for this).
   if (d === 0) {
      return false;
   }

   // Calculate the intermediate fractional point that the lines potentially intersect.
   var ua = n_a / d;
   var ub = n_b / d;

   // The fractional point will be between 0 and 1 inclusive if the lines
   // intersect.  If the fractional calculation is larger than 1 or smaller
   // than 0 the lines would need to be longer to intersect.
   if (ua >= 0 && ua <= 1 && ub >= 0 && ub <= 1)
   {
      ptIntersection.x = a1.x + (ua * (a2.x - a1.x));
      ptIntersection.y = a1.y + (ua * (a2.y - a1.y));
      return true;
   }
   return false;
}

///////// word balloon

function polyIntersect(a1, a2, poly) {
  var where = new Point(0,0);
  for(i=0; i < poly.length; i++) {
    var j = (i+1) % poly.length;
      
    if(linesIntersect(
      a1, 
      a2, 
      new Point(poly[i].x, poly[i].y), 
      new Point(poly[j].x, poly[j].y), 
    where)) return where;
  }
  return false;
}


function Session(){
  trace('+++ new Session +++');
  var STATES = ['clear', 'drawing rectangle', 'positioning stem'];
  var state = 0;
  var startPt, endPt;   
  var poly, balloonPoly;   
  var center;
  var stemIntersection = new Point(0,0);
  var travel;
  
  function trace(){
    return;
    fl.trace('[' + state + ']' + _.toArray(arguments).join(' '));
  }
  
  function rectPoly(){
    return [
      p(Math.min(startPt.x, endPt.x), Math.min(startPt.y, endPt.y)),
      p(Math.max(startPt.x, endPt.x), Math.min(startPt.y, endPt.y)),
      p(Math.max(startPt.x, endPt.x), Math.max(startPt.y, endPt.y)),
      p(Math.min(startPt.x, endPt.x), Math.max(startPt.y, endPt.y)),
    ];
  }
  
  
  function intersectionForTheta(theta){
    var pp = pointPolar(600, theta);
    return polyIntersect(center, new Point(center.x + pp.x, center.y + pp.y), poly);    
  }

  return ({
    dead:false,
    mouseDown:function(loc){
      // trace('['+state+'] mouseDown ' + loc);
      fl.drawingLayer.beginDraw(false);
      if(state === 0) {
        state = 1;
        startPt = loc;
      } else if(state == 1) {
        trace('[ERROR] mouseDown)');
      } else if(state == 2) {       
        // will render on mouseUp        
      } else {
        trace('[ERROR] mouseDown');
      }
    },
    
    mouseUp:function(loc){
      var rect, tl, br;
      var dom;
      
      trace('mouseUp');

      if(state == 1) {
        travel = pointDistance(startPt, endPt);
        if(travel < 5) {
          this.dead = true;
          return;
        }
        
        trace('mouseUp, going to state 2', startPt, endPt);
        state = 2;
        poly = rectPoly();
        center = new Point((startPt.x + endPt.x)/2, (startPt.y + endPt.y)/2);
          
      } else {
        this.dead = true;
        fl.drawingLayer.endDraw();
        trace('mouseUp; dead, travel:', travel);
        if(travel > 5) {
          trace('render', startPt, endPt, poly, balloonPoly);
          renderPath(balloonPoly);
          
          trace('poly = rectPoly()');
          poly = rectPoly();
          trace(poly);
          tl = poly[0];
          br = poly[2];
          trace('new text at', tl, br);
          dom = fl.getDocumentDOM();
          trace('dom:', dom);
          rect = {
            left:tl.x + inset,
            top: tl.y + inset,
            right:  br.x - inset, 
            bottom: br.y - inset
          };
          trace('rect inset', inset, 'LTRB:', rect.left, rect.top, rect.right, rect.bottom);
          // 
          // dom.setFillColor(0x000000);          
          dom.addNewText(rect);
          dom.setTextString(' ');
          dom.setElementTextAttr('fillColor', '#000000');
          
          // convert to a dynamic, multiline text field and try sizing it again
          dom.setElementProperty('textType', 'dynamic');
          dom.setElementProperty('lineType', 'multiline');
          dom.setTextRectangle(rect);

          // select the text
          dom.setTextSelection(0,65535);
          // alternatively: dom.mouseDblClk({x:166, y:268}, false, false, true)
          // var fill = dom.getCustomFill('selection');
          // fill.color = '#00ff00';
          // fill.style = 'solid';
          // dom.setCustomFill(fill);
          // dom.setTextRectangle(rect);//srsly do it; addNewText's w/h are ignored in favor of a signgle line
          // trace('selection length:', fl.getDocumentDOM().selection.length);
          // trace('selection w/h:', fl.getDocumentDOM().selection[0].width, fl.getDocumentDOM().selection[0].height);
          
          // fl.getDocumentDOM().setElementProperty('autoExpand', false);
          // fl.getDocumentDOM().selectNone();

          // trace('adding new text at', rect);
          // fl.getDocumentDOM().addNewText(rect);
          // 
          // fl.getDocumentDOM().setElementProperty('autoExpand', false);
          // fl.getDocumentDOM().setTextString('ravel my brigandine');
          // fl.getDocumentDOM().selectNone();
          
        }
      }
      // fl.drawingLayer.endFrame();
      fl.drawingLayer.endDraw();
      
    },
    
    mouseMove:function(loc){     
      // trace('state', '#' + state + ' ' + STATES[state] + ' move @ ' + loc);

      fl.drawingLayer.beginFrame();
      // if(state != 0) trace('session.mouseMove', loc);
      if(state == 1) {
        // trace('[1] mouseMove');
        // drawing the rectangle
        endPt = loc;
        drawPolygon(rectPoly());
      } else if(state == 2) {
        // adding the stem; where ray from center->penLoc intersects box edge
        // drawPolygon(rectPoly());
        var theta = xyToTheta(loc.x - center.x, loc.y - center.y);

        var a = intersectionForTheta(theta - 0.1); // polyIntersect(center, new Point(center.x + pp.x, center.y + pp.y), poly);
        var b = intersectionForTheta(theta + 0.1);
        var c = intersectionForTheta(theta);
        var dist = pointDistance(c, loc);
        var tip = pointSum(c, pointPolar(dist, theta));
        
        // intersectionMarker.x = c.x;
        // intersectionMarker.y = c.y;
        
        // drawPolygon([a, tip, b]);
        
        var pTheta = function(a) {
          return xyToTheta(a.x - center.x, a.y - center.y) + TWOPI;
        };
        
        var byTheta = function(a,b) {
          return pTheta(a) - pTheta(b);
        };
        
        var thetaIsBetween = function(a,b) {
          var thetas = [pTheta(a), pTheta(b)].sort();
          if(thetas[1] - thetas[0] > Math.PI) {
            // thetas are on either side of zero; wrap around
            thetas[1] += TWOPI; thetas[0] += TWOPI;
            thetas.sort();
            return function(e,i,a) {
              var t = pTheta(e) + TWOPI;
              return(t > thetas[0] && t < thetas[1]);
            };
          }
          
          return function(e,i,a) {
            var t = pTheta(e);
            return(t > thetas[0] && t < thetas[1]);
          };
        };
        
        balloonPoly = _.reject(poly, thetaIsBetween(a, b)).concat([a, tip, b]).sort(byTheta);
        // var balloonPoly = poly.concat([a, tip, b]).sort(byTheta);
        drawPolygon(balloonPoly);
        
      }
      fl.drawingLayer.endFrame();      
    },
  });
}


/////////////////////////////////////// JSFL layer
var session, inset;

function configureTool()
{
	theTool = fl.tools.activeTool;
	theTool.setToolName("WordBalloon");
	theTool.setIcon("WordBalloon.png");
	theTool.setMenuString("Word Balloon Tool");
	theTool.setToolTip("Word Balloon Tool");
	theTool.setOptionsFile( "WordBalloon.xml" );

	///////////////////////////////////////////
	// shape PI
	theTool.setPI( "shape" );
	
	//trace('   ===   configureTool (WordBalloon.jsfl)   ===   '); // runs four times on starting Flash CS6
	
	inset = 10;
  session = Session(); // always have a null session going at least
}


function notifySettingsChanged()
{
	trace('notifySettingsChanged');
	theTool = fl.tools.activeTool;
	inset = theTool.inset
}


function setCursor()
{
	fl.tools.setCursor( 0 );
}


function activate()
{
	trace('activate');
	var theTool = fl.tools.activeTool;
  session = new Session();
}


function deactivate()
{
  trace('deactivate');	
}


function handleDead(){
  if(session.dead) {
    trace('# end session');
    fl.drawingLayer.beginFrame();
    fl.drawingLayer.endDraw();
    session = Session();
  }
}  
  

function mouseDown()
{
  var loc = new Point(fl.tools.penDownLoc.x, fl.tools.penDownLoc.y);
  trace('# mouseDown', loc);
  session.mouseDown(loc);
  
  handleDead();
}


function mouseUp()
{
    var loc = new Point(fl.tools.penLoc.x, fl.tools.penLoc.y);
    trace('# mouseUp', loc);    
    session.mouseUp(loc);  
    
    handleDead();
}


function mouseMove(pt)
{
  var loc = new Point(fl.tools.penLoc.x, fl.tools.penLoc.y);
  session.mouseMove(loc);
}  

/////////////////////////////////////// Easel layer


// stage.onMouseDown = function(e) {
//   var loc = new Point(e.stageX, e.stageY);
//   trace('stage.mouse', 'down @ ' + loc);
//   session.mouseDown(loc);  
// };
//  
// 
// stage.onMouseMove = function(e) {
//   var loc = new Point(e.stageX, e.stageY); 
//   trace('stage.mouse', 'move @ ' + loc);
//   session.mouseMove(loc);  
// };
// 
// 
// stage.onMouseUp = function(e) {
//   var loc = new Point(e.stageX, e.stageY);
//   trace('stage.mouse', 'up @ ' + loc);
//   session.mouseUp(loc);  
//   if(session.dead) {
//     trace('end session');
//     fl.drawingLayer.beginFrame();
//     fl.drawingLayer.endDraw();
//     session = Session();
//   }
// };